/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.extensions.ClassNotFoundException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.utility.DialogManager;
import bluej.views.View;
import java.awt.Window;
import java.io.File;

class Identifier {
    private File projectId;
    private String packageId;
    private String qualifiedClassName;

    Identifier(Project bleujProject) {
        this.projectId = bleujProject.getProjectDir();
    }

    Identifier(Project bluejProject, Package bluejPackage) {
        this.projectId = bluejProject.getProjectDir();
        this.packageId = bluejPackage.getQualifiedName();
    }

    Identifier(Project bluejProject, Package bluejPackage, String aQualifiedClassName) {
        this.projectId = bluejProject.getProjectDir();
        this.packageId = bluejPackage.getQualifiedName();
        this.qualifiedClassName = aQualifiedClassName;
    }

    Project getBluejProject() throws ProjectNotOpenException {
        Project aProject = Project.getProject((Object)this.projectId);
        if (aProject == null) {
            throw new ProjectNotOpenException("Project " + this.projectId + " is closed");
        }
        return aProject;
    }

    Package getBluejPackage() throws ProjectNotOpenException, PackageNotFoundException {
        Project bluejProject = this.getBluejProject();
        Package bluejPkg = bluejProject.getCachedPackage(this.packageId);
        if (bluejPkg == null) {
            throw new PackageNotFoundException("Package '" + this.packageId + "' is deleted");
        }
        return bluejPkg;
    }

    PkgMgrFrame getPackageFrame() throws ProjectNotOpenException, PackageNotFoundException {
        Package thisPkg = this.getBluejPackage();
        PkgMgrFrame pmf = PkgMgrFrame.findFrame((Package)thisPkg);
        if (pmf != null) {
            return pmf;
        }
        PkgMgrFrame recentFrame = PkgMgrFrame.getMostRecent();
        if (recentFrame != null && recentFrame.isEmptyFrame()) {
            recentFrame.openPackage(thisPkg);
            return recentFrame;
        }
        pmf = PkgMgrFrame.createFrame((Package)thisPkg);
        if (recentFrame != null) {
            DialogManager.tileWindow((Window)pmf, (Window)recentFrame);
        }
        pmf.show();
        return pmf;
    }

    Class getJavaClass() throws ProjectNotOpenException, ClassNotFoundException {
        Project bluejPrj = this.getBluejProject();
        Class aClass = bluejPrj.loadClass(this.qualifiedClassName);
        if (aClass == null) {
            throw new ClassNotFoundException("Class " + this.qualifiedClassName + " Not Found");
        }
        return aClass;
    }

    ClassTarget getClassTarget() throws ProjectNotOpenException, PackageNotFoundException {
        Target aTarget;
        Package bluejPkg = this.getBluejPackage();
        String className = this.qualifiedClassName;
        int dotpos = this.qualifiedClassName.lastIndexOf(".");
        if (dotpos > 0) {
            className = this.qualifiedClassName.substring(dotpos + 1);
        }
        if ((aTarget = bluejPkg.getTarget(className)) == null) {
            throw new NullPointerException("Class " + this.qualifiedClassName + " has NO ClassTarget");
        }
        if (!(aTarget instanceof ClassTarget)) {
            throw new NullPointerException("Class " + this.qualifiedClassName + " is not of type ClassTarget");
        }
        return (ClassTarget)aTarget;
    }

    View getBluejView() throws ProjectNotOpenException, ClassNotFoundException {
        Class aClass = this.getJavaClass();
        return View.getView((Class)aClass);
    }
}

