/*
 * Decompiled with CFR 0.152.
 */
package bluej.extensions;

import bluej.compiler.JobQueue;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.extensions.BClass;
import bluej.extensions.BObject;
import bluej.extensions.BProject;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.ExtensionException;
import bluej.extensions.Identifier;
import bluej.extensions.MissingJavaFileException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.Target;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class BPackage {
    private Identifier packageId;

    BPackage(Identifier aPackageId) {
        this.packageId = aPackageId;
    }

    public void remove() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        Package parentPkg = bluejPkg.getParent();
        PackageTarget pkgTarget = (PackageTarget)parentPkg.getTarget(bluejPkg.getBaseName());
        pkgTarget.removeImmediate();
    }

    public BProject getProject() throws ProjectNotOpenException {
        Project bluejProject = this.packageId.getBluejProject();
        return new BProject(new Identifier(bluejProject));
    }

    public String getName() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        return bluejPkg.getQualifiedName();
    }

    public void reload() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        bluejPkg.reload();
    }

    public BClass newClass(String className) throws ProjectNotOpenException, PackageNotFoundException, MissingJavaFileException {
        Package bluejPkg = this.packageId.getBluejPackage();
        PkgMgrFrame bluejFrame = this.packageId.getPackageFrame();
        File classJavaFile = new File(bluejPkg.getPath(), className + ".java");
        if (!classJavaFile.canWrite()) {
            throw new MissingJavaFileException(classJavaFile.toString());
        }
        bluejFrame.createNewClass(className, null, true);
        return this.getBClass(className);
    }

    public Frame getFrame() throws ProjectNotOpenException, PackageNotFoundException {
        return this.packageId.getPackageFrame();
    }

    public BClass getBClass(String name) throws ProjectNotOpenException, PackageNotFoundException {
        Project bluejPrj = this.packageId.getBluejProject();
        Package bluejPkg = this.packageId.getBluejPackage();
        Target aTarget = bluejPkg.getTarget(name);
        if (aTarget == null) {
            return null;
        }
        if (!(aTarget instanceof ClassTarget)) {
            return null;
        }
        ClassTarget classTarget = (ClassTarget)aTarget;
        return new BClass(new Identifier(bluejPrj, bluejPkg, classTarget.getQualifiedName()));
    }

    public BClass[] getClasses() throws ProjectNotOpenException, PackageNotFoundException {
        Project bluejPrj = this.packageId.getBluejProject();
        Package bluejPkg = this.packageId.getBluejPackage();
        String pkgBasename = bluejPkg.getQualifiedName();
        if (pkgBasename.length() > 1) {
            pkgBasename = pkgBasename + ".";
        }
        List names = bluejPkg.getAllClassnames();
        BClass[] classes = new BClass[names.size()];
        ListIterator iter = names.listIterator();
        while (iter.hasNext()) {
            int index = iter.nextIndex();
            String className = pkgBasename + (String)iter.next();
            classes[index] = new BClass(new Identifier(bluejPrj, bluejPkg, className));
        }
        return classes;
    }

    public BObject getObject(String instanceName) throws ProjectNotOpenException, PackageNotFoundException {
        if (instanceName == null) {
            return null;
        }
        Package bluejPkg = this.packageId.getBluejPackage();
        PkgMgrFrame pmf = this.packageId.getPackageFrame();
        List objects = pmf.getObjectBench().getObjects();
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            ObjectWrapper wrapper = (ObjectWrapper)i.next();
            if (!instanceName.equals(wrapper.getName())) continue;
            return new BObject(wrapper);
        }
        return null;
    }

    public BObject[] getObjects() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        PkgMgrFrame pmf = this.packageId.getPackageFrame();
        List objectWrappers = pmf.getObjectBench().getObjects();
        BObject[] objects = new BObject[objectWrappers.size()];
        int index = 0;
        Iterator i = objectWrappers.iterator();
        while (i.hasNext()) {
            ObjectWrapper wrapper = (ObjectWrapper)i.next();
            objects[index] = new BObject(wrapper);
            ++index;
        }
        return objects;
    }

    public void compile(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Package bluejPkg = this.packageId.getBluejPackage();
        if (!bluejPkg.isDebuggerIdle()) {
            throw new CompilationNotStartedException("BlueJ is currently executing Java code");
        }
        bluejPkg.compile();
        if (waitCompileEnd) {
            JobQueue.getJobQueue().waitForEmptyQueue();
        }
    }

    public void compileAll(boolean waitCompileEnd) throws ProjectNotOpenException, PackageNotFoundException, CompilationNotStartedException {
        Package bluejPkg = this.packageId.getBluejPackage();
        if (!bluejPkg.isDebuggerIdle()) {
            throw new CompilationNotStartedException("BlueJ is currently executing Java code");
        }
        bluejPkg.rebuild();
        if (waitCompileEnd) {
            JobQueue.getJobQueue().waitForEmptyQueue();
        }
    }

    public BClass[] getCurrentClasses() throws ProjectNotOpenException, PackageNotFoundException {
        Package bluejPkg = this.packageId.getBluejPackage();
        Target[] targets = bluejPkg.getSelectedTargets();
        ArrayList<BClass> aList = new ArrayList<BClass>();
        for (int index = 0; index < targets.length; ++index) {
            if (!(targets[index] instanceof ClassTarget)) continue;
            ClassTarget aClass = (ClassTarget)targets[index];
            String qualifiedClassName = aClass.getQualifiedName();
            Package attachedPkg = aClass.getPackage();
            Identifier anId = new Identifier(attachedPkg.getProject(), attachedPkg, qualifiedClassName);
            aList.add(new BClass(anId));
        }
        return aList.toArray(new BClass[aList.size()]);
    }

    public BObject[] getCurrentObjects() throws ProjectNotOpenException, PackageNotFoundException {
        PkgMgrFrame bluejFrame = this.packageId.getPackageFrame();
        ObjectBench aBench = bluejFrame.getObjectBench();
        if (aBench == null) {
            return new BObject[0];
        }
        ArrayList<BObject> aList = new ArrayList<BObject>();
        ObjectWrapper aWrapper = aBench.getSelectedObject();
        if (aWrapper != null) {
            aList.add(new BObject(aWrapper));
        }
        return aList.toArray(new BObject[aList.size()]);
    }

    public File getDir() throws ProjectNotOpenException, PackageNotFoundException {
        Package aPkg = this.packageId.getBluejPackage();
        return aPkg.getPath();
    }

    public String toString() {
        try {
            Package bluejPkg = this.packageId.getBluejPackage();
            return "BPackage: " + bluejPkg.getQualifiedName();
        }
        catch (ExtensionException exc) {
            return "BPackage: INVALID";
        }
    }
}

